<?php

require_once "config.php";
require_once "functions.php";
require_once "modules/reply.php";
require_once "modules/interaction.php";
require_once "modules/ship.php";
require_once "modules/admin.php";
require_once "modules/api.php";
require_once "modules/autoreply.php";

$update = json_decode(file_get_contents("php://input"), true);
http_response_code(200);
if(!$update) exit;

$message = $update["message"] ?? null;
if(!$message) exit;

$chat_id = $message["chat"]["id"];
$user_id = $message["from"]["id"];
$text = trim($message["text"] ?? "");

if($user_id == OWNER_ID && str_starts_with($text,"/broadcast ")){

    $msg = str_replace("/broadcast ","",$text);
    
    broadcast($msg);
    
    sendMessage($chat_id,"پیام به همه گروه‌ها ارسال شد ✅");
    
    exit;
}

if(str_contains($text,"|")){

    list($key,$value) = explode("|",$text,2);

    $key = trim($key);
    $value = trim($value);

    if(isBanned($key)){
        sendMessage($chat_id,"این کلمه مجاز نیست ❌");
        exit;
    }

    if($user_id == OWNER_ID){
        saveReply($chat_id,$key,$value,true);
        sendMessage($chat_id,"ذخیره شد (سراسری) ✅");
    }else{
        saveReply($chat_id,$key,$value,false);
        sendMessage($chat_id,"ذخیره شد (گروهی) ✅");
    }

    exit;
}

if($user_id == OWNER_ID && str_starts_with($text,"/addreply ")){

    $parts = explode("|",str_replace("/addreply ","",$text));

    if(count($parts) == 2){

        $groups = loadJson("data/groups.json");
            if(!isset($groups[$chat_id])){
        $groups[$chat_id] = [
            "title"=>"",
            "members"=>[],
            "admins"=>[],
            "replies"=>[]
        ];
    }
    $groups[$chat_id]["replies"][trim($parts[0])] = trim($parts[1]);

    saveJson("data/groups.json",$groups);

    sendMessage($chat_id,"ریپلی ذخیره شد ✅");
    }

    exit;
}

if(handleAPI($chat_id,$text)){
    exit;
}

if($message["chat"]["type"] === "group" || $message["chat"]["type"] === "supergroup"){

    $groups = loadJson("data/groups.json");

    $group_id = $chat_id;

    if(!isset($groups[$group_id])){
        $groups[$group_id] = [
            "title"=>$message["chat"]["title"] ?? "",
            "members"=>[],
            "admins"=>[],
            "replies"=>[]
        ];
    }

    $groups[$group_id]["members"][$user_id] = [
        "id"=>$user_id,
        "name"=>$message["from"]["first_name"] ?? "",
        "username"=>$message["from"]["username"] ?? ""
    ];

    saveJson("data/groups.json",$groups);
}

if(!$text) exit;

if($text === "/start"){
    sendMessage($chat_id,"Bot is running ✅");
    exit;
}



if(str_starts_with($text,"هوش مصنوعی ")){

    $question = str_replace("هوش مصنوعی ","",$text);

    sendMessage($chat_id,"⏳ در حال دریافت پاسخ...");

    // اینجا بعداً API AI رو میزنم

    exit;
}

if($text === "/ship"){
    handleShip($chat_id,$message);
    exit;
}

if(handleReply($chat_id,$text)){
    exit;
}

handleInteraction($chat_id,$message);